<?php include('layouts/header.php'); ?>
<?php include('layouts/navbar.php'); ?>

<?php
$subject_title = "Anatomy";
$subject_description = "The comprehensive course series covers detailed anatomical structures, systems, and clinical correlations, broken down into essential chapters for easy learning and exam preparation.";
$total_chapters = 6;
$total_notes = 48;
$estimated_time = "30 hours";
$course_fee = 999;

$subject_gradient_color = "linear-gradient(135deg, #FF6B6B, #FF8E8E)";

$chapters_list = [
    ["title" => "Musculoskeletal System", "notes" => 8, "time" => "4 hours"],
    ["title" => "Cardiovascular System", "notes" => 6, "time" => "3.5 hours"],
    ["title" => "Central Nervous System", "notes" => 12, "time" => "6 hours"],
    ["title" => "Respiratory System", "notes" => 5, "time" => "2.5 hours"],
    ["title" => "Digestive System & Abdomen", "notes" => 10, "time" => "5 hours"],
    ["title" => "Renal & Urogenital System", "notes" => 7, "time" => "4 hours"],
];
?>

<!-- ================= STYLES ================= -->
<style>
    :root {
        --primary-green: #29a37c;
        --text-dark: #1e3a4e;
        --text-muted: #6c757d;
        --border-light: #eaeaea;
    }

    /* HERO */
    .subject-overview-header {
        background: linear-gradient(rgba(30, 58, 78, .8), rgba(30, 58, 78, .8)), url("assets/images/anatomy-bg.jpg") center/cover no-repeat;
        padding: 5.5rem 0 4.5rem;
        color: #fff;
        text-align: center;
    }

    .subject-tagline {
        background: rgba(41, 163, 124, .2);
        padding: .4rem 1rem;
        border-radius: 50px;
        font-size: .85rem;
        font-weight: 600;
    }

    .subject-title {
        font-size: clamp(2.2rem, 4vw, 3rem);
        font-weight: 800;
    }

    .subject-summary {
        max-width: 900px;
        margin: auto;
        color: rgba(255, 255, 255, .85);
        margin-top: 0.5rem;
    }

    .btn-green-fill {
        background: var(--primary-green);
        color: #fff;
        padding: .8rem 2rem;
        font-weight: 600;
        border-radius: 8px;
        border: none;
    }

    .btn-green-fill:hover {
        background: #218c6b;
    }

    /* CHAPTERS */
    .chapters-container {
        background: #fff;
        border: 1px solid var(--border-light);
        border-radius: 14px;
        overflow: hidden;
    }

    .chapter-item {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 1rem 1.5rem;
        border-bottom: 1px solid var(--border-light);
        cursor: pointer;
        transition: background 0.2s;
    }

    .chapter-item:hover {
        background: rgba(41, 163, 124, .05);
    }

    .chapter-left {
        display: flex;
        align-items: center;
        gap: 1.5rem;
    }

    .chapter-icon {
        width: 44px;
        height: 44px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        flex-shrink: 0;
    }

    .chapter-lock {
        color: #adb5bd;
        font-size: 1.2rem;
        flex-shrink: 0;
    }

    .modal-header-styled {
        background: <?php echo $subject_gradient_color; ?>;
        color: #fff;
        padding: 1.5rem;
        border-radius: .5rem .5rem 0 0;
    }

    /* BREADCRUMB */
    .breadcrumb-wrapper {
        background: #f8f9fa;
        border-bottom: 1px solid #eaeaea;
        padding: .75rem 0;
    }

    .breadcrumb {
        background: none;
        padding: 0;
        font-size: .9rem;
    }

    .breadcrumb-item a {
        color: #29a37c;
        font-weight: 500;
        text-decoration: none;
    }

    .breadcrumb-item+.breadcrumb-item::before {
        content: "›";
        color: #adb5bd;
    }

    /* GOOGLE BUTTON */
    .google-btn {
        border: 1px solid #ddd;
        border-radius: 8px;
        padding: .55rem 1rem;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: .5rem;
        cursor: pointer;
        font-size: 0.85rem;
    }

    .google-btn img {
        height: 18px;
    }

    /* ================= COURSE INFO STRIP ================= */
    .course-info-strip {
        margin-top: -2rem;
        margin-bottom: 3rem;
    }

    .info-strip-card {
        background: #fff;
        border-radius: 14px;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
        display: flex;
        align-items: stretch;
        padding: 2rem 1rem;
        gap: 1rem;
        flex-wrap: wrap;
        justify-content: space-between;
    }

    .info-item {
        flex: 1 1 180px;
        min-width: 140px;
        padding: 0 0.5rem;
        text-align: center;
    }

    .info-item strong {
        display: block;
        font-weight: 700;
        font-size: 1.3rem;
        color: #1e3a4e;
    }

    .info-item span {
        display: block;
        font-size: 0.75rem;
        color: #6c757d;
        margin-top: 0.25rem;
        line-height: 1.3;
    }

    .info-item a {
        font-size: 0.75rem;
        font-weight: 600;
        color: #29a37c;
        text-decoration: none;
    }

    .info-item a:hover {
        text-decoration: underline;
    }

    .info-divider {
        width: 1px;
        background: #eaeaea;
        margin: 0 0.5rem;
    }

    /* ================= MOBILE ================= */
    @media(max-width:768px) {
        .info-strip-card {
            flex-direction: column;
            padding: 20px 20px;
            gap: 0.3rem;
            background-color: lightcyan;
        }

        .info-divider {
            width: 100%;
            height: 1px;
            margin: 0.2rem 0;
        }

        .info-item {
            text-align: left;
            padding: 0.2rem 0;
            flex: 1 1 50px !important;
        }

        .info-item strong {
            font-size: 0.85rem;
            line-height: 1.1;
        }

        .info-item span,
        .info-item a {
            font-size: 0.7rem;
            line-height: 1.1;
        }

        .course-info-strip {
            margin-top: -0.8rem;
            margin-bottom: 1.5rem;
        }

    }
</style>

<!-- ================= BREADCRUMB ================= -->
<nav class="breadcrumb-wrapper">
    <div class="container">
        <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="index.php"><i class="fas fa-home me-1"></i>Home</a></li>
            <li class="breadcrumb-item"><a href="subjects.php">Subjects</a></li>
            <li class="breadcrumb-item active"><?php echo $subject_title; ?></li>
        </ol>
    </div>
</nav>

<!-- ================= HERO ================= -->
<section class="subject-overview-header">
    <div class="container">
        <span class="subject-tagline">Comprehensive Subject Series</span>
        <h1 class="subject-title mt-2"><?php echo $subject_title; ?></h1>
        <p class="subject-summary"><?php echo $subject_description; ?></p>

        <button class="btn btn-green-fill mt-4" data-bs-toggle="modal" data-bs-target="#enrollModal">
            Enroll in Course
        </button>
    </div>
</section>

<!-- ================= COURSE INFO STRIP ================= -->
<section class="course-info-strip">
    <div class="container">
        <div class="info-strip-card">

            <div class="info-item">
                <strong>11 Chapters</strong>
                <span>Earn a credential demonstrating your expertise</span>
            </div>

            <div class="info-divider"></div>

            <div class="info-item">
                <strong>4.7 ★</strong>
                <span>(24,929 reviews)</span>
            </div>

            <div class="info-divider"></div>

            <div class="info-item">
                <strong>42 Topics</strong>
                <span>Download necessary notes</span>
            </div>

            <div class="info-divider"></div>

            <div class="info-item info-link">
                <strong>Build Toward a Degree</strong>
                <a href="#">Learn more</a>
            </div>

        </div>
    </div>
</section>

<!-- ================= CHAPTERS ================= -->
<section class="py-5">
    <div class="container">
        <div class="chapters-container">
            <div class="p-3 fw-bold bg-light"><?php echo $total_chapters; ?> Chapters</div>
            <?php $i = 1;
            foreach ($chapters_list as $c): ?>
                <div class="chapter-item" onclick="location.href='chapter.php?id=<?php echo $i; ?>'">
                    <div class="chapter-left">
                        <div class="chapter-icon" style="background:<?php echo $subject_gradient_color; ?>">
                            <i class="fas fa-book-medical"></i>
                        </div>
                        <div>
                            <div class="text-success fw-semibold">Chapter <?php echo $i; ?></div>
                            <strong><?php echo $c['title']; ?></strong>
                            <div class="text-muted small"><?php echo $c['notes']; ?> Notes · <?php echo $c['time']; ?></div>
                        </div>
                    </div>
                    <div class="chapter-lock"><i class="fas fa-lock"></i></div>
                </div>
            <?php $i++;
            endforeach; ?>
        </div>
    </div>
</section>

<!-- ================= ENROLL MODAL ================= -->
<div class="modal fade" id="enrollModal">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0 rounded-4 shadow-lg">

            <div class="modal-header modal-header-styled">
                <h5 class="fw-bold mb-0">Enroll in <?php echo $subject_title; ?></h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body p-4">
                <form id="enrollForm">

                    <div class="row g-3">
                        <div class="col-md-6"><input class="form-control" name="name" placeholder="Full Name" required></div>
                        <div class="col-md-6"><input class="form-control" name="phone" placeholder="Mobile" required></div>
                        <div class="col-md-6"><input class="form-control" name="email" type="email" placeholder="Email" required></div>
                        <div class="col-md-6"><input class="form-control" name="city" placeholder="City"></div>
                    </div>

                    <hr class="my-4">

                    <!-- GOOGLE LOGIN -->
                    <div class="text-center mb-3">
                        <div class="google-btn" id="googleLoginBtn">
                            <img src="https://developers.google.com/identity/images/g-logo.png">
                            <span>Continue with Google</span>
                        </div>
                        <small class="text-muted d-block mt-2">Auto-fills your details securely</small>
                    </div>

                    <div class="d-flex justify-content-between align-items-center p-3 border rounded bg-light flex-wrap gap-2">
                        <strong>Course Fee: <span class="text-success fs-4">₹<?php echo $course_fee; ?></span></strong>
                        <button type="button" class="btn btn-green-fill" onclick="startPayment()">Proceed to Pay</button>
                    </div>

                </form>
            </div>

        </div>
    </div>
</div>

<!-- ================= SCRIPTS ================= -->
<script src="https://accounts.google.com/gsi/client" async defer></script>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>

<script>
    /* GOOGLE LOGIN */
    window.onload = function() {
        google.accounts.id.initialize({
            client_id: "YOUR_GOOGLE_CLIENT_ID.apps.googleusercontent.com",
            callback: handleGoogleLogin
        });
        google.accounts.id.renderButton(
            document.getElementById("googleLoginBtn"), {
                theme: "outline",
                size: "large"
            }
        );
    };

    function handleGoogleLogin(response) {
        const data = JSON.parse(atob(response.credential.split('.')[1]));
        document.querySelector('[name="name"]').value = data.name;
        document.querySelector('[name="email"]').value = data.email;
    }

    /* RAZORPAY */
    function startPayment() {
        const f = document.getElementById('enrollForm');
        if (!f.checkValidity()) {
            f.reportValidity();
            return;
        }
        new Razorpay({
            key: "RAZORPAY_KEY_ID",
            amount: <?php echo $course_fee * 100; ?>,
            currency: "INR",
            name: "MedMentor",
            description: "<?php echo $subject_title; ?> Enrollment",
            handler: function(res) {
                saveEnrollment(res.razorpay_payment_id);
            },
            prefill: {
                name: f.name.value,
                email: f.email.value,
                contact: f.phone.value
            },
            theme: {
                color: "#29a37c"
            }
        }).open();
    }

    function saveEnrollment(pid) {
        const d = new FormData(document.getElementById('enrollForm'));
        d.append("payment_id", pid);
        d.append("subject", "<?php echo $subject_title; ?>");
        fetch("enroll_submit.php", {
                method: "POST",
                body: d
            })
            .then(r => r.json())
            .then(r => {
                if (r.status === "success") {
                    location.href = "enroll-success.php";
                } else {
                    alert("Enrollment failed");
                }
            });
    }
</script>

<?php include('layouts/exam-btn.php'); ?>
<?php include('layouts/footer.php'); ?>
