<style>
    :root {
        --primary-green: #29a37c;
        --teal-button: #2488a0;
        --text-dark: #1e3a4e;
        --text-muted: #6c757d;
        --background-light: #f8f9fa;
        --border-light: #eaeaea;
        --shadow-light: rgba(0, 0, 0, 0.05);
        --body-font: 'Montserrat', sans-serif;
        --heading-font: 'Inter', sans-serif;
    }

    /* Existing styles are omitted for brevity, but assume they are present. 
       Only new or modified styles for the articles section are included here. */

    /* Articles Section */
    .articles-section {
        padding: 5rem 0;
        background-color: #F8F9FA; 
    }

    .section-header {
        text-align: center;
        margin-bottom: 4rem;
    }

    .section-subtitle {
        display: inline-block;
        color: var(--primary-green);
        font-weight: 600;
        font-size: 1rem;
        letter-spacing: 1px;
        text-transform: uppercase;
        margin-bottom: 1rem;
    }

    .section-title {
        font-size: 2.5rem;
        font-weight: 800;
        margin-bottom: 1.5rem;
        color: var(--text-dark);
    }

    .section-description {
        font-size: 1.1rem;
        color: var(--text-muted);
        max-width: 700px;
        margin: 0 auto 2rem;
    }

    /* Article Card Styles */
    .article-grid {
        display: grid;
        grid-template-columns: 1fr;
        gap: 2rem; /* Slightly larger gap for a blog/article look */
    }

    @media (min-width: 768px) {
        .article-grid {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (min-width: 1200px) {
        .article-grid {
            grid-template-columns: repeat(3, 1fr);
        }
    }

    .article-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 5px 15px var(--shadow-light);
        transition: all 0.3s ease;
        overflow: hidden; /* Ensures image corners are rounded */
        display: flex;
        flex-direction: column;
        border: 1px solid var(--border-light);
    }

    .article-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        border-color: var(--primary-green);
    }

    .article-image-container {
        width: 100%;
        height: 200px; /* Fixed height for image consistency */
        overflow: hidden;
    }

    .article-image {
        width: 100%;
        height: 100%;
        object-fit: cover; /* Ensures image covers the area without distortion */
        transition: transform 0.4s ease;
    }

    .article-card:hover .article-image {
        transform: scale(1.05);
    }

    .article-content {
        padding: 1.5rem;
        display: flex;
        flex-direction: column;
        flex-grow: 1;
    }

    .article-date {
        color: var(--primary-green);
        font-size: 0.9rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
        display: flex;
        align-items: center;
    }

    .article-date i {
        margin-right: 0.5rem;
        font-size: 0.8rem;
    }

    .article-title {
        font-size: 1.25rem;
        font-weight: 700;
        color: var(--text-dark);
        margin-bottom: 0.8rem;
    }

    .article-description {
        font-size: 0.95rem;
        color: var(--text-muted);
        margin-bottom: 1.5rem;
        flex-grow: 1;
    }

    .learn-more-btn {
        display: inline-flex;
        align-items: center;
        color: var(--teal-button);
        font-weight: 600;
        text-decoration: none;
        font-size: 1rem;
        transition: color 0.3s ease;
        align-self: flex-start; /* Aligns button to the left */
    }

    .learn-more-btn:hover {
        color: var(--primary-green);
    }

    .learn-more-btn i {
        margin-left: 0.5rem;
        font-size: 0.8rem;
        transition: transform 0.3s ease;
    }

    .learn-more-btn:hover i {
        transform: translateX(3px);
    }

    /* View All Button (reusing existing styles) */
    .view-all-container {
        text-align: center;
        margin-top: 3rem;
    }

    /* Assuming .view-all-btn styles are already present from the previous section */

</style>

<section class="articles-section" id="articles">
    <div class="container">
        <div class="section-header">
            <div class="section-subtitle">Recent Insights</div>
            <h2 class="section-title">Our Latest Articles</h2>
            <p class="section-description">
                Stay updated with expert insights, study tips, and the latest news in the medical field.
            </p>
        </div>

        <div class="article-grid">
            <div class="article-card">
                <div class="article-image-container">
                    <img src="https://picsum.photos/600/400?random=1" alt="Article about Anatomy" class="article-image">
                </div>
                <div class="article-content">
                    <div class="article-date">
                        <i class="fas fa-calendar-alt"></i> December 10, 2025
                    </div>
                    <h3 class="article-title">
                        5 Study Techniques for Mastering Gross Anatomy
                    </h3>
                    <p class="article-description">
                        Effective methods to memorize complex anatomical structures and their clinical relevance for your exams.
                    </p>
                    <a href="#" class="learn-more-btn">
                        Learn More <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>

            <div class="article-card">
                <div class="article-image-container">
                    <img src="https://picsum.photos/600/400?random=1" alt="Article about Biochemistry" class="article-image">
                </div>
                <div class="article-content">
                    <div class="article-date">
                        <i class="fas fa-calendar-alt"></i> November 28, 2025
                    </div>
                    <h3 class="article-title">
                        The Future of Precision Medicine in Biochemistry
                    </h3>
                    <p class="article-description">
                        Exploring how metabolic pathways are being targeted for personalized patient treatments.
                    </p>
                    <a href="#" class="learn-more-btn">
                        Learn More <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>

            <div class="article-card">
                <div class="article-image-container">
                    <img src="https://picsum.photos/600/400?random=1" alt="Article about Pathology" class="article-image">
                </div>
                <div class="article-content">
                    <div class="article-date">
                        <i class="fas fa-calendar-alt"></i> November 15, 2025
                    </div>
                    <h3 class="article-title">
                        Understanding Inflammatory Markers: A Pathologist's View
                    </h3>
                    <p class="article-description">
                        A detailed look at C-reactive protein (CRP) and other key indicators of systemic inflammation.
                    </p>
                    <a href="#" class="learn-more-btn">
                        Learn More <i class="fas fa-arrow-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="view-all-container">
            <a href="#" class="btn view-all-btn" style="border: 1px solid #1E3A4E;">
                View All Articles
                <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    </div>
</section>

<script>
    // Assuming the previous script handles the animation logic for .subject-card
    // Extend the animation logic to apply to the new .article-card elements as well.

    const articleCards = document.querySelectorAll('.article-card');

    // Reusing the same observer options from the previous script
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const articleCardObserver = new IntersectionObserver(function(entries) {
        entries.forEach((entry, index) => {
            if (entry.isIntersecting) {
                // Use a slightly different stagger offset if both sections are on the same page
                // Or just use the same to keep the consistency
                setTimeout(() => {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }, index * 100); 
            }
        });
    }, observerOptions);

    // Set initial state and observe each article card
    articleCards.forEach(card => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(20px)';
        card.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
        articleCardObserver.observe(card);
    });
</script>