<style>
    /* ---------------------------------------------------------------------- */
    /* 1. Base Variables & Typography (Retained from previous) */
    /* ---------------------------------------------------------------------- */
    :root {
        --primary-green: #29a37c; /* Used for features/Best Seller tag */
        --teal-button: #2488a0; /* Used for Button outline/text/hover */
        --teal-gradient-start: #2eaf98;
        --teal-gradient-end: #1f5f74;
        --text-dark: #1e3a4e;
        --text-muted: #6c757d;
        --background-light: #f8f9fa;
        --border-light: #eaeaea;
        --shadow-light: rgba(0, 0, 0, 0.05);
        --shadow-medium: rgba(0, 0, 0, 0.1);
        --body-font: 'Montserrat', sans-serif;
        --heading-font: 'Inter', sans-serif;
    }

    body {
        font-family: var(--body-font);
        color: var(--text-dark);
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    .container {
        max-width: 1100px;
        margin-left: auto;
        margin-right: auto;
        padding-left: 15px;
        padding-right: 15px;
    }

    h2, h3, h4 {
        font-family: var(--heading-font);
        font-weight: 800;
        line-height: 1.2;
    }

    /* ---------------------------------------------------------------------- */
    /* 2. Pricing Section */
    /* ---------------------------------------------------------------------- */
    .pricing-section {
        padding: 6rem 0;
        background-color: var(--background-light); /* Light background for contrast */
    }

    .pricing-header {
        text-align: center;
        margin-bottom: 4rem;
    }

    .pricing-tag {
        display: inline-block;
        color: var(--primary-green);
        background-color: rgba(41, 163, 124, 0.1); /* Light green background */
        font-weight: 700;
        font-size: 0.85rem;
        padding: 0.3rem 1rem;
        border-radius: 50px;
        text-transform: uppercase;
        letter-spacing: 1px;
        margin-bottom: 1rem;
    }

    .pricing-title {
        font-size: 3rem;
        font-weight: 800;
        margin-bottom: 1rem;
        color: var(--text-dark);
    }

    .pricing-title span {
        color: var(--teal-button); /* Highlight the word "Transparent" */
    }

    .pricing-subtitle {
        font-size: 1.1rem;
        color: var(--text-muted);
        max-width: 600px;
        margin: 0 auto;
    }

    /* ---------------------------------------------------------------------- */
    /* 3. Pricing Cards */
    /* ---------------------------------------------------------------------- */
    .pricing-grid {
        display: flex;
        justify-content: center;
        gap: 2.5rem; /* Increased gap */
        flex-wrap: wrap; /* Allows wrapping on small screens */
    }

    .pricing-card {
        background: white;
        border-radius: 16px;
        padding: 2.5rem 2rem;
        box-shadow: 0 5px 20px var(--shadow-light);
        transition: all 0.3s ease;
        max-width: 380px;
        width: 100%;
        display: flex;
        flex-direction: column;
        border: 1px solid var(--border-light);
    }

    /* Most Popular Card Styling */
    .pricing-card.popular {
        border-color: var(--teal-button); /* Teal border */
        box-shadow: 0 10px 30px rgba(36, 136, 160, 0.15);
        position: relative;
        transform: scale(1.05); /* Slightly bigger */
        z-index: 10;
    }

    .popular-tag {
        position: absolute;
        top: -15px;
        left: 50%;
        transform: translateX(-50%);
        background: linear-gradient(90deg, var(--teal-gradient-start), var(--teal-gradient-end));
        color: white;
        font-weight: 700;
        font-size: 0.8rem;
        padding: 0.4rem 1.2rem;
        border-radius: 50px;
        box-shadow: 0 5px 15px rgba(36, 136, 160, 0.4);
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    /* Card Hover Effect */
    .pricing-card:not(.popular):hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px var(--shadow-medium);
        border-color: var(--primary-green);
    }
    
    /* Header Content */
    .card-header {
        text-align: center;
        margin-bottom: 2rem;
    }

    .card-title {
        font-size: 1.5rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }

    .card-description {
        color: var(--text-muted);
        font-size: 0.95rem;
        margin-bottom: 1.5rem;
    }

    .card-price {
        font-size: 2.5rem;
        font-weight: 800;
        color: var(--text-dark);
        line-height: 1;
    }

    .price-period {
        font-size: 1rem;
        color: var(--text-muted);
        font-weight: 600;
        vertical-align: top;
        margin-left: 5px;
    }

    /* Features List */
    .card-features {
        list-style: none;
        padding: 0;
        margin: 0 0 2.5rem 0;
        flex-grow: 1;
    }

    .card-features li {
        display: flex;
        align-items: center;
        font-size: 1rem;
        color: var(--text-dark);
        margin-bottom: 1rem;
        font-weight: 500;
    }

    .card-features i {
        color: var(--primary-green);
        font-size: 1.1rem;
        margin-right: 1rem;
    }

    /* Action Button */
    .get-started-btn {
        width: 100%;
        font-weight: 700;
        padding: 1rem 1rem;
        border-radius: 10px;
        transition: all 0.3s ease;
        display: inline-block;
        text-align: center;
        text-decoration: none;
        border: none;
    }

    /* Default Button (Single Subject) */
    .get-started-btn.default {
        background-color: var(--background-light);
        color: var(--text-dark);
        border: 2px solid var(--border-light);
    }

    .get-started-btn.default:hover {
        background-color: white;
        border-color: var(--primary-green);
        color: var(--primary-green);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }

    /* Popular Button (Full Subject Bundle) */
    .get-started-btn.popular-btn {
        background: linear-gradient(90deg, var(--teal-gradient-start), var(--teal-gradient-end));
        color: white;
        box-shadow: 0 5px 20px rgba(36, 136, 160, 0.3);
    }

    .get-started-btn.popular-btn:hover {
        background: linear-gradient(90deg, var(--teal-gradient-end), var(--teal-gradient-start));
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(36, 136, 160, 0.4);
    }

    /* Responsive Adjustments */
    @media (max-width: 800px) {
        .pricing-grid {
            gap: 2rem;
            flex-direction: column;
            align-items: center;
        }
        .pricing-card.popular {
            transform: scale(1); /* Remove scale effect on small screens */
        }
        .pricing-card {
            max-width: 100%;
        }
    }
    @media (max-width: 576px) {
        .pricing-title {
            font-size: 2.5rem;
        }
        .pricing-section {
            padding: 4rem 0;
        }
    }
</style>

<section class="pricing-section" id="pricing">
    <div class="container">
        
        <div class="pricing-header">
            <div class="pricing-tag">Pricing</div>
            <h2 class="pricing-title">Simple, <span>Transparent</span> Pricing</h2>
            <p class="pricing-subtitle">
                Choose the plan that works best for your study needs. No hidden fees, no subscriptions.
            </p>
        </div>

        <div class="pricing-grid">
            
            <div class="pricing-card">
                <div class="card-header">
                    <h3 class="card-title">Single Subject</h3>
                    <p class="card-description">Perfect for focused study on one subject</p>
                    <div class="card-price">
                        ₹499<span class="price-period">/one-time</span>
                    </div>
                </div>

                <ul class="card-features">
                    <li><i class="fas fa-check-circle"></i> Complete notes for 1 subject</li>
                    <li><i class="fas fa-check-circle"></i> Downloadable PDF format</li>
                    <li><i class="fas fa-check-circle"></i> Quick revision sheets</li>
                    <li><i class="fas fa-check-circle"></i> Lifetime access</li>
                    <li><i class="fas fa-check-circle"></i> Email support</li>
                </ul>

                <a href="#" class="get-started-btn default">Get Started</a>
            </div>

            <div class="pricing-card popular">
                <div class="popular-tag">Most Popular</div>
                <div class="card-header">
                    <h3 class="card-title">All Subjects Bundle</h3>
                    <p class="card-description">Best value for comprehensive preparation</p>
                    <div class="card-price">
                        ₹1,999<span class="price-period">/one-time</span>
                    </div>
                </div>

                <ul class="card-features">
                    <li><i class="fas fa-check-circle"></i> All 8 subjects included</li>
                    <li><i class="fas fa-check-circle"></i> Downloadable PDF format</li>
                    <li><i class="fas fa-check-circle"></i> Quick revision sheets</li>
                    <li><i class="fas fa-check-circle"></i> Lifetime access</li>
                    <li><i class="fas fa-check-circle"></i> Priority support</li>
                    <li><i class="fas fa-check-circle"></i> Regular updates included</li>
                    <li><i class="fas fa-check-circle"></i> MCQ practice sets</li>
                </ul>

                <a href="#" class="get-started-btn popular-btn">Get Started</a>
            </div>

        </div>
    </div>
</section>