<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MedNotes | Medical Study Resources</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

</head>

<body>


    <style>
        :root {
            --primary-green: #29a37c;
            --teal-button: #2488a0;
            --teal-gradient-start: #2eaf98;
            --teal-gradient-end: #1f5f74;
            --text-dark: #1e3a4e;
            --text-muted: #6c757d;
            --background-light: #f8f9fa;
            --border-light: #eaeaea;
            --shadow-light: rgba(0, 0, 0, 0.05);
            --shadow-medium: rgba(0, 0, 0, 0.1);
            --body-font: 'Montserrat', sans-serif;
            --heading-font: 'Inter', sans-serif;
        }

        body {
            font-family: var(--body-font);
            color: var(--text-dark);
            line-height: 1.6;
            overflow-x: hidden;
        }


        .container {
            max-width: 1500px !important;
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            font-family: var(--heading-font);
            font-weight: 700;
        }

        /* HEADER/NAVIGATION */
        .navbar {
            padding-top: 1rem;
            padding-bottom: 1rem;
            box-shadow: 0 2px 15px rgba(0, 0, 0, 0.05);
            position: relative;
            z-index: 1000;
        }

        .navbar-brand {
            font-size: 1.5rem;
            font-weight: 700;
            display: flex;
            align-items: center;
        }

        .logo-icon {
            background-color: var(--primary-green);
            color: white;
            width: 36px;
            height: 36px;
            border-radius: 8px;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 1.3rem;
            font-weight: 700;
            margin-right: 10px;
        }

        .nav-link {
            font-weight: 500;
            color: var(--text-dark) !important;
            padding: 0.5rem 1rem !important;
            transition: all 0.3s ease;
        }

        .nav-link:hover,
        .nav-link.active {
            color: var(--primary-green) !important;
        }

        .sign-in-link {
            color: var(--text-dark) !important;
            font-weight: 500;
            text-decoration: none;
            padding-right: 1.5rem;
            transition: color 0.3s ease;
        }

        .sign-in-link:hover {
            color: var(--primary-green) !important;
        }

        .custom-gradient-btn {
            background: linear-gradient(to right, var(--teal-gradient-start), var(--teal-gradient-end));
            border: none;
            color: white;
            font-weight: 600;
            padding: 0.6rem 1.8rem;
            border-radius: 8px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(46, 175, 152, 0.25);
        }

        .custom-gradient-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(46, 175, 152, 0.35);
            color: white;
        }

        /* HERO SECTION */
        .hero-section {
            padding: 4rem 0 5rem;
            position: relative;
            overflow: hidden;
        }

        @media (min-width: 992px) {
            .hero-section {
                padding: 6rem 0 8rem;
            }
        }

        .hero-heading {
            font-size: 2.8rem;
            font-weight: 800;
            line-height: 1.2;
            margin-bottom: 1.5rem;
        }

        @media (min-width: 768px) {
            .hero-heading {
                font-size: 3.2rem;
            }
        }

        @media (min-width: 1200px) {
            .hero-heading {
                font-size: 3.8rem;
            }
        }

        .hero-subtitle {
            font-size: 1.2rem;
            color: var(--text-muted);
            margin-bottom: 2rem;
            max-width: 90%;
        }

        @media (min-width: 768px) {
            .hero-subtitle {
                font-size: 1.3rem;
                max-width: 85%;
            }
        }

        /* Trusted By Pill */
        .trusted-pill {
            display: inline-flex;
            align-items: center;
            background-color: rgba(41, 163, 124, 0.1);
            color: var(--primary-green);
            font-weight: 600;
            padding: 0.5rem 1rem 0.5rem 0.8rem;
            border-radius: 50px;
            margin-bottom: 2rem;
            font-size: 0.95rem;
        }

        .trusted-pill::before {
            content: '';
            display: inline-block;
            width: 10px;
            height: 10px;
            background-color: var(--primary-green);
            border-radius: 50%;
            margin-right: 0.7rem;
        }

        /* Hero Buttons */
        .hero-buttons {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
            margin-bottom: 3rem;
        }

        .btn-teal {
            background-color: var(--teal-button);
            border-color: var(--teal-button);
            color: white;
            font-weight: 600;
            padding: 0.8rem 2rem;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .btn-teal:hover {
            background-color: #1d7790;
            border-color: #1d7790;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(36, 136, 160, 0.25);
        }

        .btn-outline-green {
            color: var(--primary-green);
            border-color: var(--primary-green);
            font-weight: 600;
            padding: 0.8rem 2rem;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .btn-outline-green:hover {
            background-color: rgba(41, 163, 124, 0.1);
            color: var(--primary-green);
            transform: translateY(-2px);
        }

        /* Stats Section */
        .stats-row {
            margin-top: 2.5rem;
            padding-top: 2rem;
            border-top: 1px solid var(--border-light);
        }

        .stat-item {
            text-align: center;
            padding: 1rem;
        }

        @media (min-width: 768px) {
            .stat-item {
                text-align: left;
                padding: 0;
            }
        }

        .stat-number {
            font-size: 2.2rem;
            font-weight: 800;
            color: var(--teal-button);
            line-height: 1;
            margin-bottom: 0.2rem;
        }

        .stat-label {
            font-size: 0.95rem;
            color: var(--text-muted);
            font-weight: 500;
        }

        /* Image & Badge */
        .image-container {
            position: relative;
            padding-right: 0;
        }

        @media (min-width: 992px) {
            .image-container {
                padding-right: 2rem;
            }
        }

        .hero-image {
            width: 100%;
            border-radius: 12px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            transform: perspective(1000px) rotateY(-5deg);
            transition: transform 0.5s ease;
        }

        .hero-image:hover {
            transform: perspective(1000px) rotateY(0deg);
        }

        .rating-badge {
            position: absolute;
            bottom: 30px;
            left: -20px;
            background: white;
            border-radius: 12px;
            padding: 1.2rem 1.5rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            display: flex;
            align-items: center;
            max-width: 280px;
            z-index: 10;
        }

        @media (max-width: 991px) {
            .rating-badge {
                left: 50%;
                transform: translateX(-50%);
                bottom: -30px;
            }
        }

        .badge-icon {
            background: linear-gradient(135deg, #4a90e2, #2eaf98);
            color: white;
            width: 50px;
            height: 50px;
            border-radius: 10px;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 1.5rem;
            margin-right: 1rem;
            flex-shrink: 0;
        }

        .badge-text {
            line-height: 1.3;
        }

        .badge-title {
            font-weight: 700;
            font-size: 1.1rem;
            margin-bottom: 0.2rem;
        }

        .badge-subtitle {
            font-size: 0.9rem;
            color: var(--text-muted);
        }

        /* Footer */
        .footer {
            background-color: var(--background-light);
            padding: 3rem 0;
            margin-top: 4rem;
            text-align: center;
            color: var(--text-muted);
            font-size: 0.9rem;
        }

        /* Responsive adjustments */
        @media (max-width: 991.98px) {
            .navbar-collapse {
                background-color: white;
                padding: 1.5rem;
                border-radius: 10px;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
                margin-top: 1rem;
            }

            .hero-section .row {
                flex-direction: column-reverse;
            }

            .hero-heading {
                text-align: center;
            }

            .hero-subtitle {
                text-align: center;
                margin-left: auto;
                margin-right: auto;
            }

            .hero-buttons {
                justify-content: center;
            }

            .trusted-pill {
                margin-left: auto;
                margin-right: auto;
                display: flex;
                justify-content: center;
                width: fit-content;
            }
        }

        @media (max-width: 575.98px) {
            .hero-heading {
                font-size: 2.2rem;
            }

            .hero-buttons {
                flex-direction: column;
                align-items: center;
            }

            .hero-buttons .btn {
                width: 100%;
                max-width: 300px;
            }

            .stat-item {
                margin-bottom: 1.5rem;
            }
        }
    </style>