<style>
    /* ---------------------------------------------------------------------- */
    /* 1. Base Variables & Typography (Retained from previous) */
    /* ---------------------------------------------------------------------- */
    :root {
        --primary-green: #29a37c;
        --teal-button: #2488a0;
        --teal-gradient-start: #2eaf98;
        --teal-gradient-end: #1f5f74;
        --text-dark: #1e3a4e;
        --text-muted: #6c757d;
        --background-light: #f8f9fa;
        --border-light: #eaeaea;
        --shadow-medium: rgba(0, 0, 0, 0.15);
        --body-font: 'Montserrat', sans-serif;
        --heading-font: 'Inter', sans-serif;
    }

    body {
        font-family: var(--body-font);
        color: var(--text-dark);
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    .container {
        max-width: 1200px;
        margin-left: auto;
        margin-right: auto;
        padding-left: 15px;
        padding-right: 15px;
    }

    h2 {
        font-family: var(--heading-font);
        font-weight: 800;
        line-height: 1.2;
    }

    /* ---------------------------------------------------------------------- */
    /* 2. CTA Section */
    /* ---------------------------------------------------------------------- */
    .cta-section {
        padding: 4rem 0;
        background-color: var(--background-light);
        /* Light background for separation */
    }

    .cta-card {
        background: white;
        border-radius: 20px;
        /* Large border radius for soft look */
        padding: 3.5rem;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
        display: flex;
        align-items: center;
        position: relative;
        overflow: hidden;
        z-index: 1;
        /* Ensure content is above the decoration */
    }

    .cta-content {
        max-width: 60%;
        /* Limit content width for visual balance */
        position: relative;
        z-index: 2;
    }

    .cta-heading {
        font-size: 2.5rem;
        font-weight: 800;
        margin-bottom: 1rem;
        color: var(--text-dark);
    }

    /* Highlight the accent word */
    .cta-heading span {
        color: var(--teal-button);
    }

    .cta-text {
        font-size: 1.1rem;
        color: var(--text-muted);
        margin-bottom: 2rem;
        max-width: 500px;
    }

    .cta-actions {
        display: flex;
        gap: 1rem;
    }

    /* ---------------------------------------------------------------------- */
    /* 3. Button Styles */
    /* ---------------------------------------------------------------------- */
    .cta-btn {
        font-weight: 700;
        padding: 0.9rem 2.2rem;
        border-radius: 8px;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        border: 2px solid transparent;
    }

    /* Primary Button (Get All Notes) */
    .btn-primary-cta {
        background: linear-gradient(90deg, var(--teal-gradient-start), var(--teal-gradient-end));
        color: white;
        box-shadow: 0 5px 20px rgba(36, 136, 160, 0.4);
    }

    .btn-primary-cta:hover {
        background: linear-gradient(90deg, var(--teal-gradient-end), var(--teal-gradient-start));
        transform: translateY(-2px);
    }

    .btn-primary-cta i {
        margin-left: 0.5rem;
        transition: transform 0.3s ease;
    }

    .btn-primary-cta:hover i {
        transform: translateX(5px);
    }

    /* Secondary Button (View Free Sample) */
    .btn-secondary-cta {
        background: white;
        color: var(--primary-green);
        border-color: var(--primary-green);
    }

    .btn-secondary-cta:hover {
        background-color: var(--primary-green);
        color: white;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(41, 163, 124, 0.2);
    }

    /* ---------------------------------------------------------------------- */
    /* 4. Decorative Background Element */
    /* ---------------------------------------------------------------------- */
    .cta-decoration {
        position: absolute;
        top: 0;
        right: 0;
        width: 45%;
        /* Controls the size of the large circle */
        height: 100%;
        overflow: hidden;
    }

    .cta-circle {
        position: absolute;
        bottom: -50%;
        right: -30%;
        width: 150%;
        height: 150%;
        background-color: rgba(41, 163, 124, 0.05);
        /* Very light green wash */
        border-radius: 50%;
    }

    /* ---------------------------------------------------------------------- */
    /* 5. Responsive Adjustments */
    /* ---------------------------------------------------------------------- */
    @media (max-width: 992px) {
        .cta-card {
            padding: 2.5rem;
        }

        .cta-content {
            max-width: 80%;
        }

        .cta-heading {
            font-size: 2rem;
        }

        .cta-decoration {
            width: 50%;
        }

        .cta-circle {
            bottom: -30%;
            right: -20%;
        }
    }

    @media (max-width: 576px) {
        .cta-card {
            padding: 2rem;
            flex-direction: column;
            text-align: center;
        }

        .cta-content {
            max-width: 100%;
        }

        .cta-heading {
            font-size: 1.8rem;
        }

        .cta-text {
            font-size: 1rem;
        }

        .cta-actions {
            flex-direction: column;
            width: 100%;
        }

        .cta-btn {
            width: 100%;
        }

        .cta-decoration {
            display: none;
        }
    }
</style>

<section class="cta-section" id="cta">
    <div class="container">
        <div class="cta-card">

            <div class="cta-content">
                <h2 class="cta-heading">Ready to <span>Ace</span> Your Exams?</h2>
                <p class="cta-text">
                    Join thousands of medical students who trust our notes for their exam preparation. Start studying smarter today.
                </p>
                <div class="cta-actions">
                    <a href="#" class="cta-btn btn-primary-cta">
                        Get All Notes
                        <i class="fas fa-arrow-right"></i>
                    </a>
                    <a href="#" class="cta-btn btn-secondary-cta">
                        View Free Sample
                    </a>
                </div>
            </div>

            <div class="cta-decoration">
                <div class="cta-circle"></div>
            </div>
        </div>
    </div>
</section>