<style>
    /* ---------------------------------------------------------------------- */
    /* 1. Base Variables & Typography (Retained from previous) */
    /* ---------------------------------------------------------------------- */




    /* ---------------------------------------------------------------------- */
    /* 2. FAQ Section */
    /* ---------------------------------------------------------------------- */
    .faq-section {
        padding: 6rem 0;
        background-color: white;
        /* Clean white background */
    }

    .faq-header {
        text-align: center;
        margin-bottom: 4rem;
    }

    .faq-tag {
        display: inline-block;
        color: var(--primary-green);
        background-color: rgba(41, 163, 124, 0.1);
        font-weight: 700;
        font-size: 0.85rem;
        padding: 0.3rem 1rem;
        border-radius: 50px;
        text-transform: uppercase;
        letter-spacing: 1px;
        margin-bottom: 1rem;
    }

    .faq-title {
        font-size: 3rem;
        font-weight: 800;
        margin-bottom: 1rem;
        color: var(--text-dark);
    }

    /* Styling the accent word "Questions" */
    .faq-title span {
        color: var(--teal-button);
        position: relative;
    }

    /* Subtle underline/shadow effect on the accent word */
    .faq-title span::after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 100%;
        height: 8px;
        background-color: rgba(36, 136, 160, 0.1);
        /* Light teal wash */
        z-index: -1;
        border-radius: 4px;
    }

    .faq-subtitle {
        font-size: 1.1rem;
        color: var(--text-muted);
        max-width: 600px;
        margin: 0 auto;
    }

    /* ---------------------------------------------------------------------- */
    /* 3. Accordion Styling */
    /* ---------------------------------------------------------------------- */
    .accordion-item {
        margin-bottom: 1rem;
        border: 1px solid var(--border-light);
        border-radius: 12px;
        overflow: hidden;
        background-color: var(--background-light);
        /* Off-white background for each item */
        transition: box-shadow 0.3s ease;
    }

    .accordion-item:hover {
        box-shadow: 0 5px 15px var(--shadow-light);
        border-color: rgba(41, 163, 124, 0.4);
    }

    .accordion-question {
        background-color: white;
        padding: 1.2rem 1.5rem;
        cursor: pointer;
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-size: 1.1rem;
        font-weight: 600;
        color: var(--text-dark);
        transition: background-color 0.3s ease;
        border-bottom: 1px solid var(--border-light);
    }

    .accordion-question:hover {
        background-color: #f3f3f3;
    }

    .accordion-icon {
        font-size: 1rem;
        color: var(--primary-green);
        transition: transform 0.3s ease;
    }

    /* State when question is open (simulated by adding a class) */
    .accordion-item.active .accordion-question {
        color: var(--primary-green);
        background-color: var(--background-light);
    }

    .accordion-item.active .accordion-icon {
        transform: rotate(180deg);
        color: var(--teal-button);
    }

    .accordion-answer {
        max-height: 0;
        overflow: hidden;
        transition: max-height 0.4s ease-out;
        background-color: var(--background-light);
    }

    .accordion-item.active .accordion-answer {
        max-height: 500px;
        /* Arbitrarily large value for smooth transition */
        transition: max-height 0.4s ease-in;
    }

    .accordion-answer-content {
        padding: 1rem 1.5rem 1.5rem;
        font-size: 1rem;
        color: var(--text-muted);
        border-top: 1px solid var(--border-light);
        margin-top: -1px;
        /* Overlap border for cleaner look */
    }

    /* Responsive Adjustments */
    @media (max-width: 576px) {
        .faq-title {
            font-size: 2.5rem;
        }

        .accordion-question {
            font-size: 1rem;
            padding: 1rem;
        }

        .accordion-answer-content {
            padding: 0.8rem 1rem 1.2rem;
        }

        .faq-section {
            padding: 100px 0px !important;
        }

    }

    .faq-section {
        padding: 100px 400px;
    }
</style>

<section class="faq-section" id="faq">
    <div class="container">
        <div class="faq-header">
            <div class="faq-tag">FAQ</div>
            <h2 class="faq-title">Frequently Asked <span>Questions</span></h2>
            <p class="faq-subtitle">
                Got questions? We've got answers. If you can't find what you're looking for,
                reach out to our support team.
            </p>
        </div>

        <div class="accordion-list">

            <div class="accordion-item" id="faq-1">
                <div class="accordion-question">
                    What subjects are covered in the medical notes?
                    <i class="fas fa-chevron-down accordion-icon"></i>
                </div>
                <div class="accordion-answer">
                    <div class="accordion-answer-content">
                        Our comprehensive notes cover all major pre-clinical and para-clinical subjects, including **Anatomy, Physiology, Biochemistry, Pharmacology, Pathology, Microbiology, Forensic Medicine, and Community Medicine**.
                    </div>
                </div>
            </div>

            <div class="accordion-item" id="faq-2">
                <div class="accordion-question">
                    In what format are the notes available?
                    <i class="fas fa-chevron-down accordion-icon"></i>
                </div>
                <div class="accordion-answer">
                    <div class="accordion-answer-content">
                        All study materials are provided in **high-quality, downloadable PDF format**. This ensures you can access them on any device (laptop, tablet, or phone) and print them for offline study whenever you need.
                    </div>
                </div>
            </div>

            <div class="accordion-item" id="faq-3">
                <div class="accordion-question">
                    Are the notes updated with the latest curriculum?
                    <i class="fas fa-chevron-down accordion-icon"></i>
                </div>
                <div class="accordion-answer">
                    <div class="accordion-answer-content">
                        Yes. Our team of medical professionals ensures that all notes and materials are **regularly reviewed and updated** to align with the latest curriculum standards and exam patterns of major medical universities.
                    </div>
                </div>
            </div>

            <div class="accordion-item" id="faq-4">
                <div class="accordion-question">
                    Can I get a refund if I'm not satisfied?
                    <i class="fas fa-chevron-down accordion-icon"></i>
                </div>
                <div class="accordion-answer">
                    <div class="accordion-answer-content">
                        We offer a **30-day money-back guarantee**. If you are not completely satisfied with the quality of the notes, simply contact our support team within 30 days of purchase for a full refund, no questions asked.
                    </div>
                </div>
            </div>

            <div class="accordion-item" id="faq-5">
                <div class="accordion-question">
                    How do I access my notes after purchase?
                    <i class="fas fa-chevron-down accordion-icon"></i>
                </div>
                <div class="accordion-answer">
                    <div class="accordion-answer-content">
                        Immediately after a successful purchase, you will receive an email with a secure link to your **private download area**. You can access and download your notes instantly from there, and your access is lifetime.
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
    const accordionItems = document.querySelectorAll('.accordion-item');

    accordionItems.forEach(item => {
        const question = item.querySelector('.accordion-question');
        question.addEventListener('click', () => {
            // Check if the current item is already active
            const isActive = item.classList.contains('active');

            // Close all items
            accordionItems.forEach(i => {
                i.classList.remove('active');
                const answer = i.querySelector('.accordion-answer');
                answer.style.maxHeight = null;
            });

            // If it wasn't active, open the clicked item
            if (!isActive) {
                item.classList.add('active');
                const answer = item.querySelector('.accordion-answer');
                // Set max-height to the scrollHeight for smooth transition
                answer.style.maxHeight = answer.scrollHeight + "px";
            }
        });
    });
</script>