<style>
    /* ---------------------------------------------------------------------- */
    /* 1. Base Variables & Typography (Retained from previous) */
    /* ---------------------------------------------------------------------- */
    :root {
        --primary-green: #29a37c;
        --teal-button: #2488a0;
        --text-dark: #1e3a4e;
        --text-muted: #9ba7b3; /* Lighter color for text on dark background */
        --footer-bg: #1e3a4e; /* Dark background color based on image */
        --footer-logo-bg: #2488a0; /* Teal background for logo icon */
        --footer-link-hover: #ffffff;
        --body-font: 'Montserrat', sans-serif;
        --heading-font: 'Inter', sans-serif;
    }

    body {
        font-family: var(--body-font);
        color: var(--text-dark);
        line-height: 1.6;
        margin: 0;
        padding: 0;
    }

    .container {
        max-width: 1200px;
        margin-left: auto;
        margin-right: auto;
        padding-left: 15px;
        padding-right: 15px;
    }

    h4 {
        font-family: var(--heading-font);
        font-weight: 700;
        line-height: 1.2;
    }
    
    a {
        text-decoration: none;
        color: inherit;
        transition: color 0.2s ease;
    }

    /* ---------------------------------------------------------------------- */
    /* 2. Footer Section */
    /* ---------------------------------------------------------------------- */
    .site-footer {
        background-color: var(--footer-bg);
        color: var(--text-muted);
        padding: 4rem 0;
        font-size: 0.95rem;
    }

    .footer-grid {
        display: grid;
        grid-template-columns: 2fr repeat(3, 1fr); /* 4 columns: wide left, 3 equal */
        gap: 3rem;
    }

    /* Column Headings */
    .footer-grid h4 {
        color: white;
        font-size: 1.1rem;
        margin-bottom: 1.5rem;
        font-weight: 700;
    }
    
    /* Footer Links */
    .footer-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .footer-list li {
        margin-bottom: 0.8rem;
    }

    .footer-list a:hover {
        color: var(--primary-green); /* Green highlight on hover */
    }

    /* ---------------------------------------------------------------------- */
    /* 3. Left Column (MedNotes Info) */
    /* ---------------------------------------------------------------------- */
    .footer-info {
        max-width: 300px;
    }

    .footer-logo {
        display: flex;
        align-items: center;
        margin-bottom: 1.5rem;
    }

    .logo-icon {
        width: 30px;
        height: 30px;
        background-color: var(--footer-logo-bg); /* Teal background */
        color: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.1rem;
        border-radius: 6px;
        font-family: var(--heading-font);
        font-weight: 800;
        margin-right: 0.5rem;
    }
    
    .logo-text {
        color: white;
        font-size: 1.5rem;
        font-weight: 800;
        font-family: var(--heading-font);
    }
    
    .footer-contact-item {
        display: flex;
        align-items: center;
        margin-top: 1rem;
    }
    
    .footer-contact-item i {
        font-size: 1.1rem;
        margin-right: 0.8rem;
        color: var(--primary-green); /* Green icons */
    }
    
    .footer-contact-item a:hover {
        color: var(--footer-link-hover);
    }

    /* ---------------------------------------------------------------------- */
    /* 4. Bottom Footer (Copyright) */
    /* ---------------------------------------------------------------------- */
    .footer-bottom {
        text-align: center;
        border-top: 1px solid rgba(255, 255, 255, 0.1);
        padding-top: 2rem;
        margin-top: 3rem;
        font-size: 0.85rem;
    }

    /* ---------------------------------------------------------------------- */
    /* 5. Responsive Adjustments */
    /* ---------------------------------------------------------------------- */
    @media (max-width: 992px) {
        .footer-grid {
            grid-template-columns: repeat(2, 1fr);
            gap: 2.5rem;
        }
        .footer-info {
            grid-column: span 2; /* Info section spans two columns on medium screens */
            max-width: 100%;
        }
    }

    @media (max-width: 576px) {
        .footer-grid {
            grid-template-columns: 1fr; /* Single column on mobile */
            gap: 2rem;
        }
        .footer-info {
            grid-column: span 1;
        }
    }
</style>

<footer class="site-footer">
    <div class="container">
        <div class="footer-grid">
            
            <div class="footer-info">
                <div class="footer-logo">
                    <span class="logo-icon">M</span>
                    <span class="logo-text">MedMentorEdu</span>
                </div>
                <p>
                    Your trusted partner for medical exam preparation. Quality notes that help you succeed.
                </p>
                
                <div class="footer-contact-item">
                    <i class="fas fa-envelope"></i>
                    <a href="mailto:support@mednotes.com">support@mednotes.com</a>
                </div>
                <div class="footer-contact-item">
                    <i class="fas fa-phone-alt"></i>
                    <a href="tel:+919876543210">+91 98765 43210</a>
                </div>
            </div>

            <div class="footer-links">
                <h4>Subjects</h4>
                <ul class="footer-list">
                    <li><a href="#">Anatomy</a></li>
                    <li><a href="#">Biochemistry</a></li>
                    <li><a href="#">Physiology</a></li>
                    <li><a href="#">Pharmacology</a></li>
                    <li><a href="#">Pathology</a></li>
                </ul>
            </div>

            <div class="footer-links">
                <h4>Company</h4>
                <ul class="footer-list">
                    <li><a href="#">About Us</a></li>
                    <li><a href="#">Pricing</a></li>
                    <li><a href="#">FAQ</a></li>
                    <li><a href="#">Contact</a></li>
                    <li><a href="#">Blog</a></li>
                </ul>
            </div>

            <div class="footer-links">
                <h4>Legal</h4>
                <ul class="footer-list">
                    <li><a href="#">Privacy Policy</a></li>
                    <li><a href="#">Terms of Service</a></li>
                    <li><a href="#">Refund Policy</a></li>
                </ul>
            </div>
            
        </div>

        <div class="footer-bottom">
            &copy; 2023 MedNotes. All rights reserved. Designed for educational use.
        </div>
    </div>
</footer>



<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

<!-- Custom JS -->
<script>
    // Add smooth scrolling for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function(e) {
            e.preventDefault();

            const targetId = this.getAttribute('href');
            if (targetId === '#') return;

            const targetElement = document.querySelector(targetId);
            if (targetElement) {
                window.scrollTo({
                    top: targetElement.offsetTop - 80,
                    behavior: 'smooth'
                });
            }
        });
    });

    // Add animation to stats when they come into view
    const observerOptions = {
        threshold: 0.3,
        rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('animate-stats');

                // Animate counting up for stats
                const statNumbers = entry.target.querySelectorAll('.stat-number');
                statNumbers.forEach(stat => {
                    const finalValue = parseInt(stat.textContent);
                    let startValue = 0;
                    const duration = 1500;
                    const increment = finalValue / (duration / 16);

                    const updateCount = () => {
                        startValue += increment;
                        if (startValue < finalValue) {
                            stat.textContent = Math.floor(startValue) + '+';
                            setTimeout(updateCount, 16);
                        } else {
                            stat.textContent = finalValue + (stat.textContent.includes('+') ? '+' : '');
                        }
                    };

                    setTimeout(updateCount, 300);
                });
            }
        });
    }, observerOptions);

    // Observe the stats row
    const statsRow = document.querySelector('.stats-row');
    if (statsRow) observer.observe(statsRow);

    // Navbar scroll effect
    window.addEventListener('scroll', function() {
        const navbar = document.querySelector('.navbar');
        if (window.scrollY > 50) {
            navbar.style.boxShadow = '0 5px 20px rgba(0, 0, 0, 0.08)';
            navbar.style.paddingTop = '0.7rem';
            navbar.style.paddingBottom = '0.7rem';
        } else {
            navbar.style.boxShadow = '0 2px 15px rgba(0, 0, 0, 0.05)';
            navbar.style.paddingTop = '1rem';
            navbar.style.paddingBottom = '1rem';
        }
    });
</script>
</body>

</html>