<style>
    :root {
        --primary-green: #29a37c;
        --teal-button: #2488a0;
        --teal-gradient-start: #2eaf98;
        --teal-gradient-end: #1f5f74;
        --text-dark: #1e3a4e;
        --text-muted: #6c757d;
        --background-light: #f8f9fa;
        --border-light: #eaeaea;
        --shadow-light: rgba(0, 0, 0, 0.05);
        --shadow-medium: rgba(0, 0, 0, 0.1);
        --body-font: 'Montserrat', sans-serif;
        --heading-font: 'Inter', sans-serif;
    }

    body {
        font-family: var(--body-font);
        color: var(--text-dark);
        line-height: 1.6;
        overflow-x: hidden;
    }

    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
        font-family: var(--heading-font);
        font-weight: 700;
    }

    /* Study Materials Section */
    .study-materials-section {
        padding: 5rem 0;
        background-color: var(--background-light);
    }

    .section-header {
        text-align: center;
        margin-bottom: 4rem;
    }

    .section-subtitle {
        display: inline-block;
        color: var(--primary-green);
        font-weight: 600;
        font-size: 1rem;
        letter-spacing: 1px;
        text-transform: uppercase;
        margin-bottom: 1rem;
    }

    .section-title {
        font-size: 2.5rem;
        font-weight: 800;
        margin-bottom: 1.5rem;
        color: var(--text-dark);
    }

    @media (min-width: 768px) {
        .section-title {
            font-size: 3rem;
        }
    }

    .section-description {
        font-size: 1.1rem;
        color: var(--text-muted);
        max-width: 700px;
        margin: 0 auto 2rem;
    }

    /* Subject Cards */
    .subject-grid {
        display: grid;
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }

    @media (min-width: 576px) {
        .subject-grid {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (min-width: 992px) {
        .subject-grid {
            grid-template-columns: repeat(3, 1fr);
        }
    }

    @media (min-width: 1200px) {
        .subject-grid {
            grid-template-columns: repeat(4, 1fr);
        }
    }

    .subject-card {
        background: white;
        border-radius: 12px;
        padding: 1.5rem;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
        height: 100%;
        border: 1px solid rgba(0, 0, 0, 0.05);
        display: flex;
        flex-direction: column;
    }

    .subject-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        border-color: var(--primary-green);
    }

    .subject-icon {
        width: 60px;
        height: 60px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        color: white;
        margin-bottom: 1.5rem;
    }

    .subject-icon.anatomy {
        background: linear-gradient(135deg, #FF6B6B, #FF8E8E);
    }

    .subject-icon.biochemistry {
        background: linear-gradient(135deg, #4ECDC4, #8CE6DF);
    }

    .subject-icon.physiology {
        background: linear-gradient(135deg, #45B7D1, #7AD2E7);
    }

    .subject-icon.pharmacology {
        background: linear-gradient(135deg, #96CEB4, #B8E6D0);
    }

    .subject-icon.forensic {
        background: linear-gradient(135deg, #FECA57, #FFD98E);
    }

    .subject-icon.pathology {
        background: linear-gradient(135deg, #FF9FF3, #FFC5F3);
    }

    .subject-icon.microbiology {
        background: linear-gradient(135deg, #54A0FF, #8BC2FF);
    }

    .subject-icon.community {
        background: linear-gradient(135deg, #5F27CD, #8C5FDB);
    }

    .subject-title {
        font-size: 1.3rem;
        font-weight: 700;
        margin-bottom: 0.8rem;
        color: var(--text-dark);
    }

    .subject-description {
        font-size: 0.95rem;
        color: var(--text-muted);
        margin-bottom: 1.5rem;
        flex-grow: 1;
    }

    .notes-count {
        display: inline-flex;
        align-items: center;
        background-color: rgba(41, 163, 124, 0.1);
        color: var(--primary-green);
        font-weight: 600;
        font-size: 0.85rem;
        padding: 0.4rem 0.8rem;
        border-radius: 50px;
    }

    .notes-count i {
        margin-right: 0.4rem;
        font-size: 0.8rem;
    }

    /* View All Button */
    .view-all-container {
        text-align: center;
        margin-top: 3rem;
    }

    .view-all-btn {
        background: transparent;
        border: 2px solid var(--teal-button);
        color: var(--teal-button);
        font-weight: 600;
        padding: 0.8rem 2.5rem;
        border-radius: 8px;
        transition: all 0.3s ease;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    .view-all-btn:hover {
        background-color: var(--teal-button);
        color: white;
        transform: translateY(-3px);
        box-shadow: 0 8px 20px rgba(36, 136, 160, 0.2);
    }

    .view-all-btn i {
        margin-left: 0.5rem;
        transition: transform 0.3s ease;
    }

    .view-all-btn:hover i {
        transform: translateX(5px);
    }

    /* Subject Counter */
    .subject-counter {
        display: flex;
        justify-content: center;
        align-items: center;
        margin-top: 3rem;
        padding-top: 3rem;
        border-top: 1px solid rgba(0, 0, 0, 0.08);
    }

    .counter-item {
        text-align: center;
        padding: 0 1.5rem;
    }

    @media (max-width: 576px) {
        .counter-item {
            padding: 0 1rem;
        }
    }

    .counter-number {
        font-size: 2.2rem;
        font-weight: 800;
        color: var(--teal-button);
        line-height: 1;
        margin-bottom: 0.3rem;
    }

    .counter-label {
        font-size: 0.9rem;
        color: var(--text-muted);
        font-weight: 500;
    }

    /* Responsive adjustments */
    @media (max-width: 575.98px) {
        .study-materials-section {
            padding: 3rem 0;
        }

        .section-title {
            font-size: 2rem;
        }

        .subject-card {
            padding: 1.25rem;
        }
    }
</style>

<!-- Study Materials Section -->
<section class="study-materials-section" id="study-materials">
    <div class="container">
        <!-- Section Header -->
        <div class="section-header">
            <div class="section-subtitle">Study Materials</div>
            <h2 class="section-title">Explore Our Subjects</h2>
            <p class="section-description">
                Comprehensive notes covering all major medical subjects, designed to help you excel in your exams.
            </p>
        </div>

        <!-- Subjects Grid -->
        <div class="subject-grid">
            <!-- Anatomy Card -->
            <div class="subject-card">
                <div class="subject-icon anatomy">
                    <i class="fas fa-brain"></i>
                </div>
                <h3 class="subject-title">Anatomy</h3>
                <p class="subject-description">
                    Detailed anatomical structures, systems, and clinical correlations for medical students.
                </p>
                <div class="notes-count">
                    <i class="fas fa-file-alt"></i>
                    12 study notes available
                </div>
            </div>

            <!-- Biochemistry Card -->
            <div class="subject-card">
                <div class="subject-icon biochemistry">
                    <i class="fas fa-flask"></i>
                </div>
                <h3 class="subject-title">Biochemistry</h3>
                <p class="subject-description">
                    Metabolic pathways, molecular biology, and clinical biochemistry essentials.
                </p>
                <div class="notes-count">
                    <i class="fas fa-file-alt"></i>
                    8 study notes available
                </div>
            </div>

            <!-- Physiology Card -->
            <div class="subject-card">
                <div class="subject-icon physiology">
                    <i class="fas fa-heartbeat"></i>
                </div>
                <h3 class="subject-title">Physiology</h3>
                <p class="subject-description">
                    Human body functions, systems physiology, and homeostasis mechanisms.
                </p>
                <div class="notes-count">
                    <i class="fas fa-file-alt"></i>
                    10 study notes available
                </div>
            </div>

            <!-- Pharmacology Card -->
            <div class="subject-card">
                <div class="subject-icon pharmacology">
                    <i class="fas fa-pills"></i>
                </div>
                <h3 class="subject-title">Pharmacology</h3>
                <p class="subject-description">
                    Drug classifications, mechanisms of action, therapeutic uses, and side effects.
                </p>
                <div class="notes-count">
                    <i class="fas fa-file-alt"></i>
                    15 study notes available
                </div>
            </div>

            <!-- Forensic Medicine Card -->
            <div class="subject-card">
                <div class="subject-icon forensic">
                    <i class="fas fa-user-md"></i>
                </div>
                <h3 class="subject-title">Forensic Medicine</h3>
                <p class="subject-description">
                    Legal aspects of medicine, autopsy procedures, and forensic evidence examination.
                </p>
                <div class="notes-count">
                    <i class="fas fa-file-alt"></i>
                    6 study notes available
                </div>
            </div>

            <!-- Pathology Card -->
            <div class="subject-card">
                <div class="subject-icon pathology">
                    <i class="fas fa-microscope"></i>
                </div>
                <h3 class="subject-title">Pathology</h3>
                <p class="subject-description">
                    Disease processes, histopathology, and laboratory diagnosis techniques.
                </p>
                <div class="notes-count">
                    <i class="fas fa-file-alt"></i>
                    9 study notes available
                </div>
            </div>

            <!-- Microbiology Card -->
            <div class="subject-card">
                <div class="subject-icon microbiology">
                    <i class="fas fa-bacteria"></i>
                </div>
                <h3 class="subject-title">Microbiology</h3>
                <p class="subject-description">
                    Bacteriology, virology, mycology, parasitology, and immunology essentials.
                </p>
                <div class="notes-count">
                    <i class="fas fa-file-alt"></i>
                    7 study notes available
                </div>
            </div>

            <!-- Community Medicine Card -->
            <div class="subject-card">
                <div class="subject-icon community">
                    <i class="fas fa-users"></i>
                </div>
                <h3 class="subject-title">Community Medicine</h3>
                <p class="subject-description">
                    Public health, epidemiology, biostatistics, and preventive medicine.
                </p>
                <div class="notes-count">
                    <i class="fas fa-file-alt"></i>
                    5 study notes available
                </div>
            </div>
        </div>

        <!-- View All Button -->
        <div class="view-all-container">
            <a href="#" class="btn view-all-btn">
                View All Subjects
                <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    </div>
</section>



<!-- Custom JS for animations -->
<script>
    // Subject card animation on scroll
    const subjectCards = document.querySelectorAll('.subject-card');

    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };

    const cardObserver = new IntersectionObserver(function(entries) {
        entries.forEach((entry, index) => {
            if (entry.isIntersecting) {
                setTimeout(() => {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }, index * 100); // Staggered animation
            }
        });
    }, observerOptions);

    // Set initial state and observe each card
    subjectCards.forEach(card => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(20px)';
        card.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
        cardObserver.observe(card);
    });

   

    counterNumbers.forEach(number => {
        counterObserver.observe(number);
    });

    // Add click animation to cards
    subjectCards.forEach(card => {
        card.addEventListener('click', function() {
            this.style.transform = 'translateY(-12px) scale(1.02)';
            setTimeout(() => {
                this.style.transform = 'translateY(-8px)';
            }, 150);
        });
    });
</script>