<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MedNotes | Testimonials</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-green: #29a37c;
            --text-dark: #1e3a4e;
            --text-muted: #6c757d;
            --background-light: #f8f9fa;
            --border-light: #eaeaea;
            --star-color: #ffc107;
        }

        body {
            font-family: 'Inter', sans-serif;
            color: var(--text-dark);
            background-color: var(--background-light);
        }

        /* Testimonials Section */
        .testimonials-section {
            padding: 80px 0;
            background-color: white;
        }

        /* Section Header - Exactly matching image */
        .section-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-title {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 16px;
            color: var(--text-dark);
            font-family: 'Montserrat', sans-serif;
        }

        .section-subtitle {
            font-size: 1.125rem;
            color: var(--text-muted);
            max-width: 600px;
            margin: 0 auto;
            line-height: 1.6;
        }

        /* Testimonials Grid - 3 columns exactly as in image */
        .testimonials-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 30px;
            margin-bottom: 60px;
        }

        /* Testimonial Card - Exact style from image */
        .testimonial-card {
            background: white;
            border-radius: 12px;
            padding: 32px;
            border: 1px solid var(--border-light);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
            height: 100%;
        }

        .testimonial-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
        }

        /* Star Rating - Large stars exactly as in image */
        .star-rating {
            color: var(--star-color);
            font-size: 20px;
            letter-spacing: 2px;
            margin-bottom: 20px;
            display: flex;
            gap: 2px;
        }

        /* Testimonial Text - Exactly matching image style */
        .testimonial-text {
            font-size: 16px;
            line-height: 1.7;
            color: var(--text-dark);
            margin-bottom: 24px;
            font-style: normal;
        }

        /* Quote marks - subtle as in image */
        .testimonial-text::before {
            content: "''";
            color: var(--primary-green);
            font-size: 24px;
            font-weight: bold;
            margin-right: 4px;
            opacity: 0.7;
        }

        /* Author Info - Exactly as in image */
        .author-info {
            display: flex;
            align-items: center;
            padding-top: 20px;
            border-top: 1px solid var(--border-light);
        }

        .author-initials {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary-green), #2eaf98);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 18px;
            margin-right: 16px;
            flex-shrink: 0;
        }

        .author-details {
            flex-grow: 1;
        }

        .author-name {
            font-weight: 600;
            font-size: 16px;
            color: var(--text-dark);
            margin-bottom: 4px;
        }

        .author-title {
            font-size: 14px;
            color: var(--text-muted);
            font-weight: 500;
        }

        /* Responsive Design */
        @media (max-width: 992px) {
            .testimonials-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 768px) {
            .testimonials-section {
                padding: 60px 0;
            }
            
            .section-title {
                font-size: 2rem;
            }
            
            .testimonials-grid {
                grid-template-columns: 1fr;
                gap: 24px;
            }
            
            .testimonial-card {
                padding: 24px;
            }
        }

        @media (max-width: 576px) {
            .testimonials-section {
                padding: 48px 0;
            }
            
            .section-title {
                font-size: 1.75rem;
            }
            
            .section-subtitle {
                font-size: 1rem;
                padding: 0 16px;
            }
        }

        /* Container adjustments */
        .container-custom {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 24px;
        }
    </style>
</head>
<body>
    <!-- Testimonials Section -->
    <section class="testimonials-section">
        <div class="container-custom">
            <!-- Section Header -->
            <div class="section-header">
                <h2 class="section-title">Testimonials</h2>
                <!-- <p class="section-subtitle">
                    Don't just take our word for it — hear from students who've achieved success with our notes.
                </p> -->
            </div>
            
            <!-- Testimonials Grid -->
            <div class="testimonials-grid">
                <!-- Testimonial 1 -->
                <div class="testimonial-card">
                    <div class="star-rating">
                        <span>★</span><span>★</span><span>★</span><span>★</span><span>★</span>
                    </div>
                    <p class="testimonial-text">
                        These notes were a game-changer for my finals. The Anatomy notes alone helped me score 90%+ consistently. Highly recommended!
                    </p>
                    <div class="author-info">
                        <div class="author-initials">PS</div>
                        <div class="author-details">
                            <div class="author-name">Dr. Priya Sharma</div>
                            <div class="author-title">MBBS Graduate, AIIMS</div>
                        </div>
                    </div>
                </div>
                
                <!-- Testimonial 2 -->
                <div class="testimonial-card">
                    <div class="star-rating">
                        <span>★</span><span>★</span><span>★</span><span>★</span><span>★</span>
                    </div>
                    <p class="testimonial-text">
                        The Pharmacology notes are incredibly well-organized. Drug classifications and mechanisms are explained so clearly that revision became a breeze.
                    </p>
                    <div class="author-info">
                        <div class="author-initials">RV</div>
                        <div class="author-details">
                            <div class="author-name">Rahul Verma</div>
                            <div class="author-title">Final Year Medical Student</div>
                        </div>
                    </div>
                </div>
                
                <!-- Testimonial 3 -->
                <div class="testimonial-card">
                    <div class="star-rating">
                        <span>★</span><span>★</span><span>★</span><span>★</span><span>★</span>
                    </div>
                    <p class="testimonial-text">
                        I used these notes throughout my undergraduate years. The Pathology content was particularly helpful for both theory and MCQs.
                    </p>
                    <div class="author-info">
                        <div class="author-initials">SA</div>
                        <div class="author-details">
                            <div class="author-name">Dr. Sarah Ahmed</div>
                            <div class="author-title">MBBS, MD Pathology</div>
                        </div>
                    </div>
                </div>
            </div>
            
            
        </div>
    </section>

    <script>
        // Simple animation for testimonial cards
        document.addEventListener('DOMContentLoaded', function() {
            const testimonialCards = document.querySelectorAll('.testimonial-card');
            
            // Add staggered animation on load
            testimonialCards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(20px)';
                
                setTimeout(() => {
                    card.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
                    card.style.opacity = '1';
                    card.style.transform = 'translateY(0)';
                }, index * 200);
            });
            
            // Add hover effects to star ratings
            const starRatings = document.querySelectorAll('.star-rating');
            starRatings.forEach(rating => {
                const stars = rating.querySelectorAll('span');
                
                stars.forEach(star => {
                    star.style.transition = 'transform 0.2s ease';
                    
                    star.addEventListener('mouseenter', function() {
                        this.style.transform = 'scale(1.3)';
                    });
                    
                    star.addEventListener('mouseleave', function() {
                        this.style.transform = 'scale(1)';
                    });
                });
            });
        });
    </script>
</body>
</html>