
    <style>
        :root {
            --primary-green: #29a37c;
            --teal-button: #2488a0;
            --teal-gradient-start: #2eaf98;
            --teal-gradient-end: #1f5f74;
            --text-dark: #1e3a4e;
            --text-muted: #6c757d;
            --background-light: #f8f9fa;
            --border-light: #eaeaea;
            --shadow-light: rgba(0, 0, 0, 0.05);
            --shadow-medium: rgba(0, 0, 0, 0.1);
            --body-font: 'Montserrat', sans-serif;
            --heading-font: 'Inter', sans-serif;
            --accent-blue: #4a90e2;
            --accent-orange: #ff9f43;
            --accent-purple: #9b59b6;
            --accent-red: #e74c3c;
            --accent-teal: #1abc9c;
            --accent-yellow: #f1c40f;
        }

        body {
            font-family: var(--body-font);
            color: var(--text-dark);
            line-height: 1.6;
        }

        h1, h2, h3, h4, h5, h6 {
            font-family: var(--heading-font);
            font-weight: 700;
        }

        /* Why Choose Us Section */
        .why-choose-section {
            padding: 6rem 0;
            background: linear-gradient(135deg, #f8fafc 0%, #f1f8ff 100%);
            position: relative;
            overflow: hidden;
        }

        .why-choose-section::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 300px;
            height: 300px;
            background: linear-gradient(135deg, rgba(41, 163, 124, 0.05) 0%, rgba(36, 136, 160, 0.05) 100%);
            border-radius: 50%;
            transform: translate(30%, -30%);
        }

        .why-choose-section::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 200px;
            height: 200px;
            background: linear-gradient(135deg, rgba(41, 163, 124, 0.05) 0%, rgba(36, 136, 160, 0.05) 100%);
            border-radius: 50%;
            transform: translate(-30%, 30%);
        }

        /* Section Header */
        .section-header {
            text-align: center;
            margin-bottom: 4rem;
            position: relative;
            z-index: 2;
        }

        .section-subtitle {
            display: inline-block;
            color: var(--primary-green);
            font-weight: 600;
            font-size: 1rem;
            letter-spacing: 1px;
            text-transform: uppercase;
            margin-bottom: 1rem;
            padding: 0.5rem 1.2rem;
            background-color: rgba(41, 163, 124, 0.1);
            border-radius: 50px;
        }

        .section-title {
            font-size: 2.8rem;
            font-weight: 800;
            margin-bottom: 1.5rem;
            color: var(--text-dark);
        }

        .section-tagline {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--teal-button);
            margin-bottom: 1.5rem;
        }

        .section-description {
            font-size: 1.1rem;
            color: var(--text-muted);
            max-width: 700px;
            margin: 0 auto 2rem;
        }

        /* Trusted By Section */
        .trusted-section {
            background-color: white;
            border-radius: 12px;
            padding: 1.5rem 2rem;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            max-width: 500px;
            margin: 0 auto 4rem;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            z-index: 2;
        }

        .trusted-avatars {
            display: flex;
            margin-right: 1.5rem;
        }

        .avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--accent-blue), var(--accent-teal));
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 0.9rem;
            border: 3px solid white;
            margin-left: -10px;
        }

        .avatar:nth-child(2) {
            background: linear-gradient(135deg, var(--accent-orange), var(--accent-yellow));
        }

        .avatar:nth-child(3) {
            background: linear-gradient(135deg, var(--accent-purple), #8e44ad);
        }

        .avatar:nth-child(4) {
            background: linear-gradient(135deg, var(--accent-red), #c0392b);
        }

        .trusted-text {
            font-weight: 600;
            font-size: 1.1rem;
            color: var(--text-dark);
        }

        .trusted-number {
            color: var(--primary-green);
        }

        /* Features Grid */
        .features-grid {
            display: grid;
            grid-template-columns: 1fr;
            gap: 2rem;
            position: relative;
            z-index: 2;
        }

        @media (min-width: 768px) {
            .features-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (min-width: 992px) {
            .features-grid {
                grid-template-columns: repeat(3, 1fr);
            }
        }

        .feature-card {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.06);
            transition: all 0.4s ease;
            border: 1px solid rgba(0, 0, 0, 0.05);
            height: 100%;
            display: flex;
            flex-direction: column;
            position: relative;
            overflow: hidden;
        }

        .feature-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 5px;
            height: 100%;
            background: linear-gradient(to bottom, var(--primary-green), var(--teal-button));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
            border-color: rgba(41, 163, 124, 0.2);
        }

        .feature-card:hover::before {
            opacity: 1;
        }

        .feature-icon {
            width: 70px;
            height: 70px;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.8rem;
            color: white;
            margin-bottom: 1.5rem;
            transition: transform 0.3s ease;
        }

        .feature-card:hover .feature-icon {
            transform: scale(1.1);
        }

        .feature-icon.expert {
            background: linear-gradient(135deg, var(--accent-blue), #2980b9);
        }

        .feature-icon.access {
            background: linear-gradient(135deg, var(--accent-orange), #e67e22);
        }

        .feature-icon.time {
            background: linear-gradient(135deg, var(--accent-teal), #16a085);
        }

        .feature-icon.exam {
            background: linear-gradient(135deg, var(--accent-purple), #8e44ad);
        }

        .feature-icon.updates {
            background: linear-gradient(135deg, var(--accent-red), #c0392b);
        }

        .feature-icon.support {
            background: linear-gradient(135deg, var(--accent-yellow), #f39c12);
        }

        .feature-title {
            font-size: 1.3rem;
            font-weight: 700;
            margin-bottom: 1rem;
            color: var(--text-dark);
        }

        .feature-description {
            font-size: 0.95rem;
            color: var(--text-muted);
            line-height: 1.7;
        }

        /* Stats Banner */
        .stats-banner {
            background: linear-gradient(135deg, var(--primary-green), var(--teal-button));
            border-radius: 16px;
            padding: 3rem 2rem;
            margin-top: 4rem;
            color: white;
            text-align: center;
            position: relative;
            z-index: 2;
            overflow: hidden;
        }

        .stats-banner::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 200px;
            height: 200px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            transform: translate(30%, -30%);
        }

        .stats-banner::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 150px;
            height: 150px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 50%;
            transform: translate(-30%, 30%);
        }

        .banner-title {
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 2rem;
            position: relative;
            z-index: 2;
        }

        .banner-stats {
            display: flex;
            justify-content: space-around;
            flex-wrap: wrap;
            gap: 2rem;
            position: relative;
            z-index: 2;
        }

        .banner-stat {
            text-align: center;
            min-width: 150px;
        }

        .banner-number {
            font-size: 2.5rem;
            font-weight: 800;
            margin-bottom: 0.5rem;
            display: block;
        }

        .banner-label {
            font-size: 1rem;
            font-weight: 500;
            opacity: 0.9;
        }

        /* Responsive adjustments */
        @media (max-width: 991.98px) {
            .why-choose-section {
                padding: 4rem 0;
            }
            
            .section-title {
                font-size: 2.3rem;
            }
            
            .section-tagline {
                font-size: 1.3rem;
            }
        }

        @media (max-width: 767.98px) {
            .section-title {
                font-size: 2rem;
            }
            
            .trusted-section {
                flex-direction: column;
                text-align: center;
                padding: 1.5rem;
            }
            
            .trusted-avatars {
                margin-right: 0;
                margin-bottom: 1rem;
                justify-content: center;
            }
            
            .feature-card {
                padding: 1.5rem;
            }
            
            .banner-stats {
                flex-direction: column;
                gap: 1.5rem;
            }
            
            .banner-title {
                font-size: 1.7rem;
            }
        }

        @media (max-width: 575.98px) {
            .why-choose-section {
                padding: 3rem 0;
            }
            
            .section-title {
                font-size: 1.8rem;
            }
            
            .section-tagline {
                font-size: 1.2rem;
            }
            
            .feature-icon {
                width: 60px;
                height: 60px;
                font-size: 1.5rem;
            }
        }
    </style>

    <!-- Why Choose Us Section -->
    <section class="why-choose-section" id="why-choose-us">
        <div class="container">
            <!-- Section Header -->
            <div class="section-header">
                <div class="section-subtitle">Why Choose Us</div>
                <h2 class="section-title">Study Smarter, Not Harder</h2>
                <h3 class="section-tagline">We understand the challenges of medical education.</h3>
                <p class="section-description">
                    That's why we've created study materials that are designed to maximize retention and help you succeed in your exams.
                </p>
                
                <!-- Trusted By -->
                <div class="trusted-section">
                    <div class="trusted-avatars">
                        <div class="avatar">AS</div>
                        <div class="avatar">MK</div>
                        <div class="avatar">RJ</div>
                        <div class="avatar">PL</div>
                    </div>
                    <div class="trusted-text">
                        <span class="trusted-number">10,000+</span> students trust us
                    </div>
                </div>
            </div>
            
            <!-- Features Grid -->
            <div class="features-grid">
                <!-- Expert-Crafted Content -->
                <div class="feature-card">
                    <div class="feature-icon expert">
                        <i class="fas fa-user-md"></i>
                    </div>
                    <h3 class="feature-title">Expert-Crafted Content</h3>
                    <p class="feature-description">
                        Notes written by medical professionals and top-scoring students with years of experience, ensuring accuracy and relevance.
                    </p>
                </div>
                
                <!-- Instant Access -->
                <div class="feature-card">
                    <div class="feature-icon access">
                        <i class="fas fa-download"></i>
                    </div>
                    <h3 class="feature-title">Instant Access</h3>
                    <p class="feature-description">
                        Download notes instantly in PDF format. Study offline, anytime, anywhere on any device without internet dependency.
                    </p>
                </div>
                
                <!-- Time-Saving Summaries -->
                <div class="feature-card">
                    <div class="feature-icon time">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3 class="feature-title">Time-Saving Summaries</h3>
                    <p class="feature-description">
                        Concise summaries and quick revision sheets to maximize your study efficiency. Focus on what matters most for exams.
                    </p>
                </div>
                
                <!-- Exam-Focused Material -->
                <div class="feature-card">
                    <div class="feature-icon exam">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <h3 class="feature-title">Exam-Focused Material</h3>
                    <p class="feature-description">
                        Content structured around actual exam patterns, high-yield topics, and commonly asked questions to boost your scores.
                    </p>
                </div>
                
                <!-- Regular Updates -->
                <div class="feature-card">
                    <div class="feature-icon updates">
                        <i class="fas fa-sync-alt"></i>
                    </div>
                    <h3 class="feature-title">Regular Updates</h3>
                    <p class="feature-description">
                        Notes are continuously updated to reflect the latest curriculum and exam guidelines, keeping you ahead of changes.
                    </p>
                </div>
                
                <!-- 24/7 Support -->
                <div class="feature-card">
                    <div class="feature-icon support">
                        <i class="fas fa-headset"></i>
                    </div>
                    <h3 class="feature-title">24/7 Support</h3>
                    <p class="feature-description">
                        Get help whenever you need it. Our support team is always ready to assist you with any questions or technical issues.
                    </p>
                </div>
            </div>
            
            <!-- Stats Banner -->
            <div class="stats-banner">
                <h3 class="banner-title">Join Thousands of Successful Medical Students</h3>
                <div class="banner-stats">
                    <div class="banner-stat">
                        <span class="banner-number">98%</span>
                        <span class="banner-label">Exam Pass Rate</span>
                    </div>
                    <div class="banner-stat">
                        <span class="banner-number">4.9</span>
                        <span class="banner-label">Average Rating</span>
                    </div>
                    <div class="banner-stat">
                        <span class="banner-number">10K+</span>
                        <span class="banner-label">Satisfied Students</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Custom JS for animations -->
    <script>
        // Feature cards animation on scroll
        const featureCards = document.querySelectorAll('.feature-card');
        
        const featureObserver = new IntersectionObserver(function(entries) {
            entries.forEach((entry, index) => {
                if (entry.isIntersecting) {
                    setTimeout(() => {
                        entry.target.style.opacity = '1';
                        entry.target.style.transform = 'translateY(0)';
                    }, index * 100); // Staggered animation
                }
            });
        }, {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        });
        
        // Set initial state and observe each card
        featureCards.forEach(card => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(30px)';
            card.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
            featureObserver.observe(card);
        });
        
        // Banner stats animation
        const bannerStats = document.querySelector('.stats-banner');
        const bannerNumbers = document.querySelectorAll('.banner-number');
        
        const bannerObserver = new IntersectionObserver(function(entries) {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    bannerNumbers.forEach((number, index) => {
                        setTimeout(() => {
                            animateCounter(number);
                        }, index * 300);
                    });
                    bannerObserver.unobserve(entry.target);
                }
            });
        }, { threshold: 0.5 });
        
        bannerObserver.observe(bannerStats);
        
        function animateCounter(element) {
            const finalValue = parseFloat(element.textContent.replace('+', ''));
            const hasPlus = element.textContent.includes('+');
            const isPercentage = element.textContent.includes('%');
            let startValue = 0;
            const duration = 1500;
            const increment = finalValue / (duration / 16);
            
            const updateCount = () => {
                startValue += increment;
                if (startValue < finalValue) {
                    if (isPercentage) {
                        element.textContent = Math.floor(startValue) + '%';
                    } else if (hasPlus) {
                        element.textContent = Math.floor(startValue) + '+';
                    } else {
                        element.textContent = startValue.toFixed(1);
                    }
                    setTimeout(updateCount, 16);
                } else {
                    if (isPercentage) {
                        element.textContent = finalValue + '%';
                    } else if (hasPlus) {
                        element.textContent = finalValue + '+';
                    } else {
                        element.textContent = finalValue.toFixed(1);
                    }
                }
            };
            
            updateCount();
        }
        
        // Avatar hover effect
        const avatars = document.querySelectorAll('.avatar');
        avatars.forEach(avatar => {
            avatar.addEventListener('mouseenter', function() {
                this.style.transform = 'translateY(-5px) scale(1.1)';
                this.style.zIndex = '10';
            });
            
            avatar.addEventListener('mouseleave', function() {
                this.style.transform = 'translateY(0) scale(1)';
                this.style.zIndex = '1';
            });
        });
        
        // Feature card hover enhancement
        featureCards.forEach(card => {
            card.addEventListener('mouseenter', function() {
                const icon = this.querySelector('.feature-icon');
                icon.style.transform = 'scale(1.1) rotate(5deg)';
            });
            
            card.addEventListener('mouseleave', function() {
                const icon = this.querySelector('.feature-icon');
                icon.style.transform = 'scale(1) rotate(0)';
            });
        });
    </script>
